% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShinySimulatorGlobal.R
\name{simulate_function}
\alias{simulate_function}
\title{A function to simulate frequency - severity of insurance claims. The function applies severity cap, reinsurance structure for each and every loss claim, reinsurance structure for each and aggregate claims. The function allows for piecewise pareto slices.}
\usage{
simulate_function(
  numOfSimulations,
  freq_params,
  sev_params,
  seedSetBinary,
  seedValue,
  freqDistr,
  sevDistr,
  paretoSlice,
  pareto_slice_times,
  slice_pareto_alphas,
  slice_pareto_x_ms,
  sevCapBinary,
  sev_cap_amount,
  reinsuranceStructureEEL,
  reinsurance_structure_eel_dedctible_amount,
  reinsurance_structure_eel_limit_amount,
  reinsuranceStructureAL,
  reinsurance_structure_al_dedctible_amount,
  reinsurance_structure_al_limit_amount,
  reinsuranceStructureLimitedReinstatements,
  reinsuranceStructureReinstatementLimit,
  multiprocessing
)
}
\arguments{
\item{numOfSimulations}{The number of simulations to run.}

\item{freq_params}{A vector of the frequency distribution parameters.}

\item{sev_params}{A vector of the severity distribution parameters.}

\item{seedSetBinary}{True if there is a fixed seed, otherwise false.}

\item{seedValue}{The seed value.}

\item{freqDistr}{The frequency distribution. Options are as per the freq_dist_options.}

\item{sevDistr}{The severity distribution. Options are as per the sev_dist_options.}

\item{paretoSlice}{True if there is Pareto slicing.}

\item{pareto_slice_times}{The number of Pareto slices.}

\item{slice_pareto_alphas}{A vector of Pareto slices' aphla parameters.}

\item{slice_pareto_x_ms}{A vector of Pareto slices' x_m parameters.}

\item{sevCapBinary}{True if there is a severity cap.}

\item{sev_cap_amount}{The severity cap amount.}

\item{reinsuranceStructureEEL}{The chosen reinsurance structure for each and every loss claim.}

\item{reinsurance_structure_eel_dedctible_amount}{The deductible for each and every loss reinsurance structure.}

\item{reinsurance_structure_eel_limit_amount}{The limit for each and every loss reinsurance structure.}

\item{reinsuranceStructureAL}{The chosen reinsurance structure for aggregate claims.}

\item{reinsurance_structure_al_dedctible_amount}{The deductible for aggregate reinsurance structure.}

\item{reinsurance_structure_al_limit_amount}{The limit for aggregate reinsurance structure.}

\item{reinsuranceStructureLimitedReinstatements}{True if there is a limit in reinstatements, otherwise false.}

\item{reinsuranceStructureReinstatementLimit}{The reinstatement limit.}

\item{multiprocessing}{True if multiprocessing is used, otherwise false.}
}
\value{
A data frame with claims counts, ceded claims and the number of reinstatements used.
}
\description{
A function to simulate frequency - severity of insurance claims. The function applies severity cap, reinsurance structure for each and every loss claim, reinsurance structure for each and aggregate claims. The function allows for piecewise pareto slices.
}
