% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_extremal.R
\name{nd.extremal}
\alias{nd.extremal}
\title{Extremal distance with top-\eqn{k} eigenvalues}
\usage{
nd.extremal(A, out.dist = TRUE, k = ceiling(nrow(A)/5))
}
\arguments{
\item{A}{a list of length \code{N} containing adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{k}{the number of largest eigenvalues to be used.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times k)} matrix where each row is top-\eqn{k} Laplacian eigenvalues.}
}
}
\description{
Extremal distance (\code{nd.extremal}) is a type of spectral distance measures on two graphs' graph Laplacian,
\deqn{L := D-A}
where \eqn{A} is an adjacency matrix and \eqn{D_{ii}=\sum_j A_{ij}}. It takes top-\eqn{k} eigenvalues from
graph Laplacian matrices and take normalized sum of squared differences as metric. Note that it is
\emph{1. non-negative}, \emph{2. separated}, \emph{3. symmetric}, and satisfies \emph{4. triangle inequality} in that
it is indeed a metric.
}
\examples{
## generate two types of adjacency matrices of size (3-by-3)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2); diag(mattype1)=0;
mattype2 = ceiling((mat2+t(mat2))/2); diag(mattype2)=0;

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## Compute Distance Matrix and Visualize
output = nd.extremal(A, out.dist=FALSE, k=2)
image(output$D, main="two group case")

}
\references{
\insertRef{jakobson_extremal_2002}{NetworkDistance}
}
