% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_moments.R
\name{nd.moments}
\alias{nd.moments}
\title{Log Moments Distance}
\usage{
nd.moments(
  A,
  k = 3,
  metric = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  out.dist = TRUE
)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{k}{the integer order of moments. If \eqn{k} is too large, it may incur numerical overflow.}

\item{metric}{type of distance measures for log-moment features. See \code{\link[stats]{dist}} for more details.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
For a graph with an adjacency matrix \eqn{A}, \emph{graph moment} is defined as
\deqn{\rho_m (A) = tr(A/n)^m}
where \eqn{n} is the number of vertices and \eqn{m} is an order of the moment. \code{nd.moments} computes
pairwise distances based on log of graph moments from \eqn{m=1} to \eqn{m=k}.
}
\examples{
## load example data
data(graph20)

## compute distance based on different k's.
out3 <- nd.moments(graph20, k=3, out.dist=FALSE)
out5 <- nd.moments(graph20, k=5, out.dist=FALSE)
out7 <- nd.moments(graph20, k=7, out.dist=FALSE)
out9 <- nd.moments(graph20, k=9, out.dist=FALSE)

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(out3$D[,20:1], col=gray(0:32/32), axes=FALSE, main="k=3")
image(out5$D[,20:1], col=gray(0:32/32), axes=FALSE, main="k=5")
image(out7$D[,20:1], col=gray(0:32/32), axes=FALSE, main="k=7")
image(out9$D[,20:1], col=gray(0:32/32), axes=FALSE, main="k=9")
par(opar)

}
\references{
\insertRef{mukherjee_clustering_2017}{NetworkDistance}
}
