% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{pathlengths}
\alias{pathlengths}
\title{Characteristic Path Lengths}
\usage{
pathlengths(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to FALSE.
Set to TRUE for weighted measures of ASPL, ASPLi, ecc, and D}
}
\value{
Returns a list of ASPL, ASPLi, ecc, and D of a network
}
\description{
Computes global average shortest path length (ASPL),
local average shortest path length (ASPLi),
eccentricity (ecc),
and diameter (D) of a network
}
\examples{
A<-TMFG(neoOpen)$A

unweighted_PL<-pathlengths(A)

weighted_PL<-pathlengths(A,weighted=TRUE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
