% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{neuralgrouptest}
\alias{neuralgrouptest}
\title{Neural Network Group Statistics Tests}
\usage{
neuralgrouptest(groups, nstat, correction = c("bonferroni", "FDR"))
}
\arguments{
\item{groups}{Participant vector of desired groups (\strong{see examples})}

\item{nstat}{A statistic vector (whole-network) or matrix (ROI) from the \code{\link{neuralstat}} function}

\item{correction}{Multiple comparisons correction for ROI testing.
Defaults to local false discovery rate (i.e., "FDR")}
}
\value{
Returns test statistics for given groups and statistics
}
\description{
Statistical test for group differences for global or local network characteristics of neural network data
(still in testing phase)
}
\examples{
\dontrun{
neuralarray <- convertConnBrainMat()

filteredneuralarray <- neuralnetfilter(neuralarray, method = "threshold", thres = .50)

AverageShortestPathLength <- neuralstat(filteredneuralarray, statistic = "ASPL")

Degree <- neuralstat(filteredneuralarray, statistic = "deg")

groups <- c(rep(1,30),rep(2,30))

WholeNetwork_t-test <- neuralstattest(groups, AverageShortestPathLength)

ROI_t-test <- neuralstattest(groups, Degree)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
