% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{sim.swn}
\alias{sim.swn}
\title{Simulate Small-world Network}
\usage{
sim.swn(nodes, n, pos = 0.8, ran = c(0.3, 0.7), nei = 1, p = 0.5,
  corr = FALSE, replace = NULL, ordinal = FALSE, ordLevels = NULL)
}
\arguments{
\item{nodes}{Number of nodes in the simulated network}

\item{n}{Number of cases in the simulated dataset}

\item{pos}{Proportion of positive correlations in the simulated network}

\item{ran}{Range of correlations in the simulated network}

\item{nei}{Adjusts the number of connections each node has to neighboring nodes (see \link[igraph]{sample_smallworld})}

\item{p}{Adjusts the rewiring probability (default is .5).
p > .5 rewires the simulated network closer to a random network.
p < .5 rewires the simulated network closer to a lattice network}

\item{corr}{Should the simualted network be a correlation network?
Defaults to FALSE.
Set to TRUE for a simulated correlation network}

\item{replace}{If noise > 0, then should participants be sampled with replacement?
Defaults to TRUE.
Set to FALSE to not allow the potential for participants to be consecutively entered
into the simulated dataset.}

\item{ordinal}{Should simulated continuous data be converted to ordinal?
Defaults to FALSE.
Set to TRUE for simulated ordinal data}

\item{ordLevels}{If ordinal = TRUE, then how many levels should be used?
Defaults to NULL.
Set to desired number of intervals (defaults to 5)}
}
\value{
Returns a list that includes the simulated network (simNetwork),
simulated data (simData), and simulated correlation matrix (simRho)
}
\description{
Simulates a small-world network based on specified topological properties.
Data will also be simulated based on the true network structure
}
\examples{
sim.norm <- sim.swn(25, 500, nei = 3)

sim.Likert <- sim.swn(25, 500, nei = 3,
replace = TRUE, ordinal = TRUE, ordLevels = 5)
}
\references{
Csardi, G., & Nepusz, T. (2006).
The \emph{igraph} software package for complex network research.
\emph{InterJournal, Complex Systems}, \emph{1695}(5), 1-9.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
