% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMFG.R
\name{TMFG}
\alias{TMFG}
\title{Triangulated Maximally Filtered Graph}
\usage{
TMFG(data, normal = FALSE, na.data = c("pairwise", "listwise", "fiml",
  "none"), depend = FALSE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{normal}{Should data be transformed to a normal distribution?
Input must be a dataset.
Defaults to FALSE.
Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \link[qgraph]{cor_auto} function)}

\item{na.data}{How should missing data be handled?
For "listwise" deletion the \code{\link{na.omit}} function is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\link[psych]{corFiml}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{depend}{Is network a dependency (or directed) network?
Defaults to FALSE.
Set to TRUE to generate a TMFG-filtered dependency network
(output obtained from the \code{\link{depend}} function)}
}
\value{
Returns a list containing:

\item{A}{The filtered adjacency matrix}

\item{separators}{The separators (3-cliques) in the network
(wrapper output for \link[NetworkToolbox]{LoGo})}

\item{cliques}{The cliques (4-cliques) in the network
(wrapper output for \link[NetworkToolbox]{LoGo})}
}
\description{
Applies the Triangulated Maximally Filtered Graph (TMFG) filtering method
(\strong{Please see and cite Massara et al., 2016})
}
\examples{
TMFG.net <- TMFG(neoOpen)

}
\references{
Christensen, A. P., Kenett, Y. N., Aste, T., Silvia, P. J., & Kwapil, T. R. (2018).
Network structure of the Wisconsin Schizotypy Scales-Short Forms: Examining psychometric network filtering approaches.
\emph{Behavior Research Methods}, 1-20.
doi: \href{https://doi.org/10.3758/s13428-018-1032-9}{10.3758/s13428-018-1032-9}

Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Network filtering for big data: Triangulated maximally filtered graph.
\emph{Journal of Complex Networks}, \emph{5}, 161-178.
doi: \href{https://doi.org/10.1093/comnet/cnw015}{10.1093/comnet/cnw015}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
