% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpmFPperm.R
\name{cpmFPperm}
\alias{cpmFPperm}
\title{Connectome-based Predictive Modeling--Fingerprinting Permutation}
\usage{
cpmFPperm(session1, session2, iter = 1000, progBar = TRUE)
}
\arguments{
\item{session1}{Array from \code{\link{convertConnBrainMat}} function
(first session)}

\item{session2}{Array from \code{\link{convertConnBrainMat}} function
(second session)}

\item{iter}{Number of iterations to perform.
Defaults to 1,000}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}
}
\value{
Returns a matrix containing the percentage and
number of correctly identified subjects for sessions 1 and 2
}
\description{
Applies the Connectome-based Predictive Modeling approach to neural data.
This method identifies individuals based on their specific connectivity patterns.
\strong{Please cite Finn et al., 2015; Rosenberg et al., 2016; Shen et al., 2017}
}
\references{
Finn, E. S., Shen, X., Scheinost, D., Rosenberg, M. D., Huang, J., Chun, M. M., Papademetris, X., Constable, R. T. (2015).
Functional connectome fingerprinting: Identifying individuals using patterns of brain connectivity.
\emph{Nature Neuroscience}, \emph{18}, 1664-1671.
doi: \href{https://doi.org/10.1038/nn.4135}{10.1038/nn.4135}

Rosenberg, M. D., Finn, E. S., Scheinost, D., Papademetris, X., Shen, X., Constable, R. T., Chun, M. M. (2016).
A neuromarker of sustained attention from whole-brain functional connectivity.
\emph{Nature Neuroscience}, \emph{19}, 165-171.
doi: \href{https://doi.org/10.1038/nn.4179}{10.1038/nn.4179}

Shen, X. Finn, E. S., Scheinost, D., Rosenberg, M. D., Chun, M. M., Papademetris, X., Constable, R. T. (2017).
Using connectome-based predictive modeling to predict individual behavior from brain connectivity.
\emph{Nature Protocols}, \emph{12}, 506-518.
doi: \href{https://doi.org/10.1038/nprot.2016.178}{10.1038/nprot.2016.178}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
