% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stable.R
\name{stable}
\alias{stable}
\title{Stabilizing Nodes}
\usage{
stable(A, comm = c("walktrap", "louvain"), cent = c("betweenness",
  "rspbc", "closeness", "strength", "degree", "hybrid"), ...)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{Can be a vector of community assignments or community detection algorithms
("walktrap" or "louvain") can be used to determine the number of factors.
Defaults to "walktrap".
Set to "louvain" for louvain community detection}

\item{cent}{Centrality measure to be used.
Defaults to "strength".}

\item{...}{Additional arguments for community detection algorithms}
}
\value{
A matrix containing the within-community centrality value for each node
}
\description{
Computes the within-community centrality for each node in the network
}
\examples{
A<-TMFG(neoOpen)$A

stabilizing <- stable(A, comm = "walktrap")

}
\references{
Blanken, T. F., Deserno, M. K., Dalege, J., Borsboom, D., Blanken, P., Kerkhof, G. A., & Cramer, A. O. (2018).
The role of stabilizing and communicating symptoms given overlapping communities in psychopathology networks.
\emph{Scientific Reports}, \emph{8}, 5854.
doi: \href{https://doi.org/10.1038/s41598-018-24224-2}{10.1038/s41598-018-24224-2}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
