% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMFG.R
\name{TMFG}
\alias{TMFG}
\title{Triangulated Maximally Filtered Graph}
\usage{
TMFG(data, normal = FALSE, na.data = c("pairwise", "listwise", "fiml",
  "none"), depend = FALSE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{normal}{Should data be transformed to a normal distribution?
Input must be a dataset.
Defaults to \code{FALSE}.
Data is not transformed to be normal.
Set to \code{TRUE} if data should be transformed to be normal
(computes correlations using the \code{\link[qgraph]{cor_auto}} function)}

\item{na.data}{How should missing data be handled?
For \code{"listwise"} deletion the \code{\link{na.omit}} function is applied.
Set to \code{"fiml"} for Full Information Maxmimum Likelihood (\code{\link[psych]{corFiml}}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{depend}{Is network a dependency (or directed) network?
Defaults to \code{FALSE}.
Set to \code{TRUE} to generate a TMFG-filtered dependency network
(output obtained from the \code{\link[NetworkToolbox]{depend}} function)}
}
\value{
Returns a list containing:

\item{A}{The filtered adjacency matrix}

\item{separators}{The separators (3-cliques) in the network
(wrapper output for \code{\link[NetworkToolbox]{LoGo}})}

\item{cliques}{The cliques (4-cliques) in the network
(wrapper output for \code{\link[NetworkToolbox]{LoGo}})}
}
\description{
Applies the Triangulated Maximally Filtered Graph (TMFG) filtering method
(\strong{Please see and cite Massara et al., 2016}). The TMFG method uses a structural
constraint that limits the number of zero-order correlations included in the network
(3n - 6; where \emph{n} is the number of variables). The TMFG algorithm begins by
identifying four variables which have the largest sum of correlations to all other
variables. Then, it iteratively adds each variable with the largest sum of three
correlations to nodes already in the network until all variables have been added to
the network. This structure can be associated with the inverse correlation matrix
(i.e., precision matrix) to be turned into a GGM (i.e., partial correlation network)
by using \code{\link[NetworkToolbox]{LoGo}}.
}
\examples{
TMFG.net <- TMFG(neoOpen)

}
\references{
Christensen, A. P., Kenett, Y. N., Aste, T., Silvia, P. J., & Kwapil, T. R. (2018).
Network structure of the Wisconsin Schizotypy Scales-Short Forms: Examining psychometric network filtering approaches.
\emph{Behavior Research Methods}, 1-20.
doi: \href{https://doi.org/10.3758/s13428-018-1032-9}{10.3758/s13428-018-1032-9}

Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Network filtering for big data: Triangulated maximally filtered graph.
\emph{Journal of Complex Networks}, \emph{5}, 161-178.
doi: \href{https://doi.org/10.1093/comnet/cnw015}{10.1093/comnet/cnw015}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
