% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Distance}
\usage{
distance(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to \code{FALSE}.
Set to \code{TRUE} for weighted measure of distance}
}
\value{
A distance matrix of the network
}
\description{
Computes distance matrix of the network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

#Unweighted
Du <- distance(A)

#Weighted
Dw <- distance(A, weighted = TRUE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
