% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rspbc.R
\name{rspbc}
\alias{rspbc}
\title{Randomized Shortest Paths Betweenness Centrality}
\usage{
rspbc(A, beta = 0.01, comm = NULL)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{beta}{Sets the beta parameter.
Defaults to \code{0.01} (recommended).
Beta > 0.01 measure gets closer to weighted
betweenness centrality (10) and beta < 0.01
measure gets closer to degree (.0001)}

\item{comm}{Vector.
Community vector containing a value for each node.
Computes "bridge" RSPBC, where the number of times
a node is used on a random path between to another community}
}
\value{
A vector of randomized shortest paths betweenness
centrality values for each node in the network
}
\description{
Computes betweenness centrality based on randomized shortest paths
of each node in a network
(\strong{Please see and cite Kivimaki et al., 2016})
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

rspbc <- rspbc(A, beta=0.01)

}
\references{
Kivimaki, I., Lebichot, B., Saramaki, J., & Saerens, M. (2016).
Two betweenness centrality measures based on Randomized Shortest Paths.
\emph{Scientific Reports}, \emph{6}, 19668.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
