% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pred_sens}
\alias{pred_sens}
\title{Predicted values for Lek profile method}
\usage{
pred_sens(mat_in, mod_in, var_sel, step_val, fun_in, resp_name)
}
\arguments{
\item{mat_in}{\code{data.frame} of only the explanatory variables used to create model}

\item{mod_in}{any model object with a predict method}

\item{var_sel}{chr string of explanatory variable to select}

\item{step_val}{number of values to sequence range of selected explanatory variable}

\item{fun_in}{function defining the method of holding explanatory variables constant}

\item{resp_name}{chr string of response variable names for correct labelling}
}
\value{
A \code{\link{data.frame}} of predictions and the sequence values of the selected explanatory variable
}
\description{
Get predicted values for Lek Profile method, used iteratively in \code{\link{lekprofile}}
}
\details{
Gets predicted output for a model's response variable based on matrix of explanatory variables that are restricted following Lek's profile method. The selected explanatory variable is sequenced across a range of values. All other explanatory variables are held constant at the value specified by \code{fun_in}.
}
\examples{
## using nnet

library(nnet)

data(neuraldat)
set.seed(123)

mod <- nnet(Y1 ~ X1 + X2 + X3, data = neuraldat, size = 5)

mat_in <- neuraldat[, c('X1', 'X2', 'X3')]
pred_sens(mat_in, mod, 'X1', 100, function(x) quantile(x, 0.5), 'Y1')
}
\seealso{
lekprofile
}

