% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensTimePlot.R
\name{SensTimePlot}
\alias{SensTimePlot}
\title{Sensitivity analysis plot over time of the data}
\usage{
SensTimePlot(object, fdata = NULL, date.var = NULL, facet = FALSE)
}
\arguments{
\item{object}{fitted neural network model or \code{array} containing the raw
sensitivities from the function \code{SensAnalysisMLP}}

\item{fdata}{\code{data.frame} containing the data to evaluate the sensitivity of the model.
Not needed if the raw sensitivities has been passed as \code{object}}

\item{date.var}{\code{Posixct vector} with the date of each sample of \code{fdata}
If \code{NULL}, the first variable with Posixct format of \code{fdata} is used as dates}

\item{facet}{\code{logical} if \code{TRUE}, function \code{facet_grid} from}

\item{...}{arguments passed to the function to use S3 method
package \code{\link[ggplot2]{ggplot2-package}} to divide the plot
for each input variable.}
}
\value{
\code{geom_line} plots for the inputs variables representing the
sensitivity of each output respect to the inputs over time
}
\description{
Plot of sensitivity of the neural network output respect
to the inputs over the time variable from the data provided
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- as.data.frame(DAILY_DEMAND_TR)

## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,2:3] <- fdata.Reg.tr[,2:3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                           data = nntrData,
                           linear.output = TRUE,
                           size = hidden_neurons,
                           decay = decay,
                           maxit = iters)
# Try SensAnalysisMLP
NeuralSens::SensTimePlot(nnetmod, fdata = nntrData, date.var = fdata[,1])
}
