% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensMLP.R
\name{summary.SensMLP}
\alias{summary.SensMLP}
\title{Summary Method for the SensMLP Class}
\usage{
\method{summary}{SensMLP}(object, ...)
}
\arguments{
\item{object}{\code{SensMLP} object created by \code{\link[NeuralSens]{SensAnalysisMLP}}}

\item{...}{additional parameters}
}
\value{
summary object of the \code{SensMLP} object passed
}
\description{
Print the sensitivity metrics of a \code{SensMLP} object.
This metrics are the mean sensitivity, the standard deviation
of sensitivities and the mean of sensitivities square
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR

## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                           data = nntrData,
                           linear.output = TRUE,
                           size = hidden_neurons,
                           decay = decay,
                           maxit = iters)
# Try SensAnalysisMLP
sens <- NeuralSens::SensAnalysisMLP(nnetmod, trData = nntrData, plot = FALSE)
summary(sens)
}
