% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HessFeaturePlot.R
\name{HessFeaturePlot}
\alias{HessFeaturePlot}
\title{Feature sensitivity plot}
\usage{
HessFeaturePlot(object, fdata = NULL, ...)
}
\arguments{
\item{object}{fitted neural network model or \code{array} containing the raw
sensitivities from the function \code{\link[NeuralSens]{SensAnalysisMLP}}}

\item{fdata}{\code{data.frame} containing the data to evaluate the sensitivity of the model.
Not needed if the raw sensitivities has been passed as \code{object}}

\item{...}{further arguments that should be passed to  \code{\link[NeuralSens]{SensAnalysisMLP}} function}
}
\value{
list of Feature sensitivity plot as described in
\url{https://www.r-bloggers.com/2019/03/a-gentle-introduction-to-shap-values-in-r/}
}
\description{
Show the distribution of the sensitivities of the output
in \code{geom_sina()} plot which color depends on the input values
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR

## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                           data = nntrData,
                           linear.output = TRUE,
                           size = hidden_neurons,
                           decay = decay,
                           maxit = iters)
# Try SensAnalysisMLP
hess <- NeuralSens::HessianMLP(nnetmod, trData = nntrData, plot = FALSE)
NeuralSens::HessFeaturePlot(hess)
}
