\name{Generators}
\alias{Generators}
\title{
Generators (points) of the tesselation generated by a nominal variable.
}
\description{
With the parameters resulting from fitting a nominal logistic model to the row scores for a given variable, the function calculates all the information necessary to plot the tessellation generated by the fit. The final user will not normally use this function. 
}
\usage{
Generators(beta)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{beta}{
Matrix with the estimated parameters for a given nominal variable. It has as many rows as the number
  of categories minus one and three columns (one for the constant and other two for the x-y coordinates on the plane). 
}
}
\value{
An object of class \code{"voronoiprob"}.  This has the components:

  \item{x }{x-coordinates for the real points (Vertices of the tessellation).}
  \item{y }{y-coordinates for the real points (Vertices of the tessellation).}
  \item{n1 }{vector with the first neighbours of the real points}
  \item{n2 }{vector with the second neighbours of the real points}
  \item{n3 }{vector with the third neighbours of the real points}
  \item{dummy.x }{x-coordinates for the dummy points}
  \item{dummy.y }{y-coordinates for the dummy points}
  \item{ndummy }{Number of dummies}
  \item{IndReal }{Matrix with the indices of each real point in the tessellation}
  \item{Centers }{Matrix with the points resulting from inverting the tessellation}
  \item{hideCat }{Vector to indicate if there are some hidden categories}
  \item{equivRegiones }{Matrix with the new re-numbered categories (when some are hidden)}
}
\references{
Hern\'andez S\'anchez, J. C., & Vicente-Villard\'on, J. L. (2013). Logistic biplot for nominal data. arXiv preprint arXiv:1309.5486.

Gower, J. & Hand, D. (1996), \emph{Biplots, Monographs on statistics and applied probability} 54. London: Chapman and Hall., 277 pp.

Evans, D. & Jones, S. (1987), \emph{Detecting voronoi (area of influence) polygons}
,Mathematical Geology 19(6), 523--537.

Hartvigsen, D. (1992), \emph{Recognizing voronoi diagrams with linear programming},
ORSA Journal on Computing 4, 369--374.

Schoenberg, F., Ferguson, T. & Li, C. (2003), \emph{Inverting dirichlet tesselations},
Computer journal 46(1), 76--83.
}
\author{
Julio Cesar Hernandez Sanchez, Jose Luis Vicente-Villardon

Maintainer: Julio Cesar Hernandez Sanchez <juliocesar_avila@usal.es>
}
\examples{
  data(HairColor)
  data = data.matrix(HairColor)
  xEM = NominalLogBiplotEM(data, dim = 2,showResults = FALSE)
  nomreg = polylogist(data[,2],xEM$RowCoordinates[,1:2],penalization=0.1)
  tesselation = Generators(nomreg$beta)
  tesselation
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{tesselations}
\keyword{invert}
\keyword{voronoi}
