% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MissingValues.R
\name{MissingValues}
\alias{MissingValues}
\title{Missing value replacement}
\usage{
MissingValues(featuredata, sampledata = NULL, metabolitedata = NULL,
  feature.cutoff = 0.8, sample.cutoff = 0.8, method = c("knn", "replace",
  "none"), k = 10, featuremax.knn = 0.8, samplemax.knn = 0.8,
  seed = 100, saveoutput = FALSE, outputname = "nomissing")
}
\arguments{
\item{featuredata}{A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.
See NormalizeMets Vignette for details.}

\item{sampledata}{A dataframe with sample information matching featuredata.}

\item{metabolitedata}{A dataframe with metabolite information matching featuredata.}

\item{feature.cutoff}{A value between zero and one. Used to exclude features that have 
a large proportion of missing values. If the proportion of
missing values is equal to or more than the feature.cutoff, that feature will be deleted.}

\item{sample.cutoff}{A value between zero and one. Used to exclude samples that have 
a large proportion of missing values. If the proportion of missing
values is equal to or more than the sample.cutoff in any row, that whole sample
will be deleted.}

\item{method}{Missing value replacement method. Should be either "knn" (the kth nearest neighbour algorithm),
"replace" (replacing by half the minimum detectable signal ), or "none".}

\item{k}{The number of nearest neighbours to be used in the knn algorithm}

\item{featuremax.knn}{For the knn algorithm. The maximum proportion of missing data allowed in 
any feature. For any features with more than featuremax.knn proportion missing,
missing values are imputed using the overall mean per sample.}

\item{samplemax.knn}{For the knn algorithm. The maximum proportion of
missing data allowed in any sample. If any sample has more than 
samplemax.knn missing data, the program halts and reports an error.}

\item{seed}{For the knn algorithm for very large matrices. An integer, denoting state for random number generation in R.}

\item{saveoutput}{A logical indicating whether the output should be saved.
If \code{TRUE}, the results will be saved as a csv file.}

\item{outputname}{The name of the output file if the output has to be saved.}
}
\value{
The output is an object of class
\code{\link[NormalizeMets:alldata]{alldata}}.
}
\description{
Missing value imputation for metabolomics data matrices
}
\examples{

    data(alldata_eg)
    featuredata_eg<-alldata_eg$featuredata
    sampledata_eg<-alldata_eg$sampledata
    metabolitedata_eg<-alldata_eg$metabolitedata
    logdata <- LogTransform(featuredata_eg)
    
    imp <-  MissingValues(logdata$featuredata,sampledata_eg,metabolitedata_eg,
                      feature.cutof=0.8, sample.cutoff=0.8, method="knn")
    imp
    dataview(imp$featuredata)                       

}
\author{
Alysha M De Livera, Gavriel Olshansky
}
