% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nitrogen_efficiency.R
\name{calc_n_efficiency}
\alias{calc_n_efficiency}
\title{Calculate nitrogen use efficiency and leaching based on N surplus}
\usage{
calc_n_efficiency(
  B_LU_BRP,
  B_SOILTYPE_AGR,
  B_GWL_CLASS,
  B_AER_CBS,
  A_SOM_LOI,
  A_CLAY_MI,
  D_PBI,
  D_K,
  D_PH_DELTA,
  leaching_to,
  M_GREEN = FALSE,
  B_FERT_NORM_FR = 1
)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soilBRP}

\item{B_GWL_CLASS}{(character) The groundwater table class}

\item{B_AER_CBS}{(character) The agricultural economic region in the Netherlands (CBS, 2016)}

\item{A_SOM_LOI}{(numeric) The percentage organic matter in the soil (\%)}

\item{A_CLAY_MI}{(numeric) The clay content of the soil (\%)}

\item{D_PBI}{(numeric) The value of phosphate availability calculated by \code{\link{calc_phosphate_availability}}}

\item{D_K}{(numeric) The value of K-index calculated by \code{\link{calc_potassium_availability}}}

\item{D_PH_DELTA}{(numeric) The pH difference with the optimal pH.}

\item{leaching_to}{(character) whether it computes N leaching to groundwater ("gw") or to surface water ("ow")}

\item{M_GREEN}{(boolean) A soil measure. Are catch crops sown after main crop (optional, option: yes or no)}

\item{B_FERT_NORM_FR}{(numeric) The fraction of the application norm utilized}
}
\value{
The estimated index for the nitrogen use efficiency, as being affected by soil properties. A numeric value.
}
\description{
This function gives an indication of the nitrogen use efficiency, the function calculates the N surplus and the resulting N leaching
}
\examples{
calc_n_efficiency(1019,'dekzand','GtIV','Zuidwest-Brabant',4.5,3.5,0.8,0.6,0.2,78,FALSE,1)
calc_n_efficiency(256,'veen','GtII','Centraal Veehouderijgebied',4.5,3.5,0.8,0.6,0.2,250,FALSE,1)

}
