% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterretention.R
\name{pFpara_class}
\alias{pFpara_class}
\title{Parameter estimation based on class of Staringreeks (Tabel 3, Wosten 2001)}
\usage{
pFpara_class(Pklei, Pleem, Psom, M50)
}
\arguments{
\item{Pklei}{(numeric) The clay (<2um) content of the soil (\%)}

\item{Pleem}{(numeric) The loam (<50um) content of the soil (\%) Pleem > 0}

\item{Psom}{(numeric) The organic matter content of the soil (\%) Psom > 0}

\item{M50}{(numeric)size of  sand fraction (um)}
}
\value{
a table with the following columns:
ThetaR (numeric) residual water content (cm3/cm3)
ThetaS (numeric) saturated water content (cm3/cm3)
alfa (numeric)  related to the inverse of the air entry suction, alfa > 0 (1/cm) 
n (numeric)  a measure of the pore-size distribution, n>1, dimensionless
ksat (numeric) saturated hydraulic conductivity (cm/d)
}
\description{
Parameter estimation based on class of Staringreeks (Tabel 3, Wosten 2001)
}
\examples{
pFpara_class(Pklei = 25, Pleem = 15, Psom = 4.5,M50 = 150)
pFpara_class(Pklei = 45, Pleem = 3, Psom = 4.5,M50 = 150)

}
