\name{draw_elev3Drgl_OCN}
\alias{draw_elev3Drgl_OCN}
\title{Plot 3D map of elevation generated by an OCN via rgl rendering}
\usage{
draw_elev3Drgl_OCN(OCN, coarseGrain = c(1, 1), chooseCM = FALSE,
  addColorbar = FALSE, drawRiver = FALSE, thrADraw = 0.002 *
  OCN$FD$nNodes* OCN$cellsize^2, riverColor = "#00CCFF", 
  min_lwd = 1, max_lwd = 8, ...)
}
\arguments{
\item{OCN}{List as produced by \code{\link{landscape_OCN}}.}

\item{coarseGrain}{2x1 vector (only effective if \code{chooseCM = FALSE}). For aesthetic purposes, the elevation map can be coarse-grained into a \code{OCN$dimX/coarseGrain[1]}-by-\code{OCN$dimX/coarseGrain[2]} 
domain, where each cell's elevation is the average of elevations of the corresponding \code{coarseGrain[1]}-by-\code{coarseGrain[2]} cells of the original elevation field. 
\code{coarseGrain[1]} and \code{coarseGrain[2]} must be divisors of \code{OCN$dimX} and \code{OCN$dimY}, respectively. \code{coarseGrain = c(2,2)} is often sufficient to achieve a good graphical results for large 
(i.e. at least 100x100 nodes) OCNs.}

\item{chooseCM}{Index of catchment to display (only effective if \code{OCN$nOutlet > 1}). It can be a logical, or a scalar within \code{1:length(OCN$nOutlet)}. 
If \code{TRUE}, the catchment with largest area is displayed. Note that, if the size of the chosen catchment is too small (e.g. \code{OCN$CM$A[chooseCM] < 5*OCN$cellsize^2}), an error might occur due to failure in triangulation.}

\item{addColorbar}{If \code{TRUE}, add colorbar to the plot.}

\item{drawRiver}{If \code{TRUE}, draw the OCN on top of the elevation field.}

\item{thrADraw}{Threshold drainage area value used to display the network.}

\item{riverColor}{Color used to plot the river.}

\item{min_lwd, max_lwd}{Minimum and maximum values of line width used to display the OCN (actual line width is proportional to the square root of drainage area).}

\item{...}{Further parameters passed to function \code{\link{persp3d}}. The default value for \code{aspect} is \code{c(OCN$dimX/sqrt(OCN$dimX*OCN$dimY, OCN$dimY/sqrt(OCN$dimX*OCN$dimY, 1))}.}
}
\value{
No output is returned.
}
\description{
Function that plots the 3D elevation map generated by an OCN.
}
\details{
This function makes use of the \code{\link{rgl}} rendering system. To export the figure in raster format, use \code{\link{rgl.snapshot}}. 
To export in vectorial format, use \code{\link{rgl.postscript}} (but note that this might produce rendering issues, see \code{\link{rgl}} for details).
The function will attempt at drawing a contour of the plotted entity (i.e. the lattice or a catchment, depending on \code{chooseCM}) at null elevation, and drawing polygons connecting this contour with the lattice/catchment contour at the real elevation. If \code{chooseCM != FALSE}, this might result in errors owing to failure of \code{\link{polygon3d}} in triangulating the polygons.  
}
\examples{
\dontrun{
draw_elev3Drgl_OCN(landscape_OCN(OCN_20))
}

\dontrun{
# 1a) draw the 3D representation of a single catchment within an OCN 
# generated with nOutlet = "All" and add draw the river on top of it
OCN <- landscape_OCN(OCN_400_Allout, displayUpdates = 2) # this takes some minutes
draw_elev3Drgl_OCN(OCN, chooseCM = 983, drawRiver = TRUE)

# 1b) draw the 3D representation of the largest catchment within the OCN 
# (here polygon3d may fail at plotting the polygon at zero elevation)   
draw_elev3Drgl_OCN(OCN, chooseCM = TRUE) 

# 1c) draw the 3D representation of the whole OCN
# and enhance the aspect ratio of Z coordinates 
# with respect to the default value (the final result will be ugly):  
draw_elev3Drgl_OCN(OCN, aspect = c(1, 1, 0.2))

# 1d) same as above, but operate coarse graining for better aesthetics: 
draw_elev3Drgl_OCN(OCN, coarseGrain = c(5,5), aspect = c(1, 1, 0.2))

# 2) draw the 3D representation of a single catchment of an OCN generated
# with periodicBoundaries = TRUE
# (note that the real shape of the catchment is drawn)
OCN <- landscape_OCN(OCN_300_4out_PB, displayUpdates = 2) # this takes some minutes
draw_elev3Drgl_OCN(OCN, chooseCM = TRUE) 
}
}
