% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimHenson.r
\name{opiInitialise_for_SimHenson}
\alias{opiInitialise_for_SimHenson}
\title{opiInitialise_for_SimHenson}
\arguments{
\item{type}{A single character that is:
\itemize{
\item \code{N} for using the A and B values from the Normals in Henson et al (2000)
\item \code{G} for using the A and B values from the Glaucomas in Henson et al (2000)
\item \code{C} for using the A and B values from the Combined in Henson et al (2000)
\item \code{X} to specify your own A and B values as parameters
}}

\item{A}{Coefficient of \code{t} in the formula (ignored if \code{type != 'X'}).}

\item{B}{Addend of \code{t} in the formula (ignored if \code{type != 'X'}).}

\item{cap}{Maximum dB value for the stdev of the FoS curve.}

\item{maxStim}{The maximum stimulus value (0 dB) in cd/\eqn{\mbox{m}^2}{m^2}.}

\item{...}{Any other parameters you like, they are ignored.}
}
\value{
A list with elements:
\itemize{
\item \code{err} NULL if initialised, msg otherwise
}
}
\description{
Simulates responses using a Frequency of Seeing (FoS) curve.

For internal use only, use \code{opiInitialize()}.

The FoS is modelled as a cumulative Gaussian function over dB with
standard deviation equal to \code{min(cap, exp( A * t + B))}, where
t is the threshold/mean of the FoS in dB.
All values are in dB relative to \code{maxStim}.
}
\examples{
    # Set up a simple simulation for white-on-white perimetry
chooseOpi("SimHenson")
res <- opiInitialize(type = "C", cap = 6)
if (!is.null(res$err))
  stop(paste("opiInitialize() failed:", res$err))

}
