% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImoVifa.r
\name{opiQueryDevice_for_ImoVifa}
\alias{opiQueryDevice_for_ImoVifa}
\title{Implementation of opiQueryDevice for the ImoVifa machine.}
\value{
A list containing:
\itemize{
\item \code{err} \code{NULL} if there was no error, a string message if there is an error.
\item \code{rightEyex} x co-ordinates of right pupil (pixels from image centre, left < 0)
\item \code{rightEyey} y co-ordinates of right pupil (pixels from image centre, up > 0)
\item \code{leftEyex} x co-ordinates of left pupil (pixels from image centre, left < 0)
\item \code{leftEyey} y co-ordinates of left pupil (pixels from image centre, up > 0)
\item \code{leftEyed} Diameter of left pupil (pixels)
\item \code{rightEyed} Diameter of right pupil (pixels)
}
}
\description{
This is for internal use only. Use \code{\link[=opiQueryDevice]{opiQueryDevice()}} after
\code{chooseOPI("ImoVifa")} to call this function.
}
\examples{
\dontrun{
chooseOpi("ImoVifa")
opiInitialise(list(port = 50001, ip = "localhost"))
opiSetup(list(eye = "BOTH"))
result <- opiQueryDevice()
}

}
\seealso{
\code{\link[=opiQueryDevice]{opiQueryDevice()}}
}
