% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSFD.R
\name{OSFD}
\alias{OSFD}
\title{Output space-filling design}
\usage{
OSFD(
  D = NULL,
  f,
  p,
  q,
  n_ini = NA,
  n,
  scale = TRUE,
  method = "EI",
  CAND = NULL,
  rand_out = FALSE,
  rand_in = FALSE
)
}
\arguments{
\item{D}{a matrix of the initial design. If not specified, a random Latin hypercube design of size n_ini and dimension p will be generated as initial design.}

\item{f}{black-box function.}

\item{p}{input dimension.}

\item{q}{output dimension.}

\item{n_ini}{the size of initial design. This initial size must be specified if D is not provided.}

\item{n}{the size of the final design.}

\item{scale}{whether to scale the output points to 0 to 1 for each dimension.}

\item{method}{two choices: 'EI' or 'Greedy'; the default is 'EI'.}

\item{CAND}{the candidate points in the input space. If Null, it will be automatically generated.}

\item{rand_out}{whether to use random uniform points or quasi random points by twinning algorithm for generating points in spheres for output space approximation. The default value is FALSE.}

\item{rand_in}{whether to use random uniform points or quasi random points by twinning algorithm for generating points in spheres for input space candidate sets. The default value is FALSE.}
}
\value{
\item{D}{the final design points in the input space}
\item{Y}{the output points}
}
\description{
This function is for producing designs that fill the output space.
}
\details{
\code{OSFD} produces a design that fills the output space using the sequential algorithm by Wang et al. (2023).
}
\examples{
# test function: inverse-radius function (Wang et.al 2023)
inverse_r = function(x){
epsilon = 0.1
y1=1/(x[1]^2+x[2]^2+epsilon^2)^(1/2)
if (x[2]==0){
 y2 = 0
}else if (x[1]==0) {
  y2 = pi/2}else{
    y2 = atan(x[2]/x[1])
  }
return (c(y1=y1,y2=y2))
}

set.seed(2022)
p = 2
q = 2
f = inverse_r
n_ini = 10
n = 50
osfd = OSFD(f=f,p=p,q=q,n_ini=n_ini,n=n)
D = osfd$D
Y = osfd$Y

}
\references{
Wang, Shangkun, Adam P. Generale, Surya R. Kalidindi, and V. Roshan Joseph. "Sequential Designs for Filling Output Spaces." Technometrics, to appear (2023).
}
