% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsMap.R
\name{pointsMap}
\alias{pointsMap}
\title{Get map for lat-long points}
\usage{
pointsMap(lat, long, data, ext = 0.07, fx = 0.05, fy = fx, type = "osm",
  zoom = NULL, minNumTiles = 9L, mergeTiles = TRUE, map = NULL,
  utm = FALSE, proj = putm(long = long), plot = TRUE, add = FALSE,
  scale = TRUE, quiet = FALSE, pch = 3, col = "red", cex = 1,
  pargs = NULL, ...)
}
\arguments{
\item{lat, long}{Latitude (North/South) and longitude (East/West) coordinates in decimal degrees}

\item{data}{Optional: data.frame with the columns \code{lat} and \code{long}}

\item{ext}{Extension added in each direction if a single coordinate is given. DEFAULT: 0.07}

\item{fx, fy}{Extend factors (additional map space around actual points)
passed to custom version of \code{\link{extendrange}}. DEFAULT: 0.05}

\item{type}{Tile server in \code{\link[OpenStreetMap]{openmap}}}

\item{zoom, minNumTiles, mergeTiles}{Arguments passed to \code{\link[OpenStreetMap]{openmap}}}

\item{map}{Optional map object. If given, it is not downloaded again.
Useful to project maps in a second step. DEFAULT: NULL}

\item{utm}{Logical: Convert map to UTM (or other \code{proj})?
Consumes some extra time. DEFAULT: FALSE}

\item{proj}{proj4 character string or CRS object to project to.
Only used if utm=TRUE. DEFAULT: \code{\link{putm}(long=long)}}

\item{plot}{Logical: Should map be plotted and points added? DEFAULT: TRUE}

\item{add}{Logical: add points to existing map? DEFAULT: FALSE}

\item{scale}{Logical: should \code{\link{scaleBar}} be added? DEFAULT: TRUE}

\item{quiet}{Logical: suppress progress messages? DEFAULT: FALSE}

\item{pch, col, cex}{Arguments passed to \code{\link{points}}. DEFAULT: 3, "red", 1}

\item{pargs}{List of arguments passed to \code{\link{points}} like lwd, type, cex...}

\item{\dots}{Further arguments passed to \code{\link{scaleBar}} like abslen, ndiv, ...}
}
\value{
Map returned by \code{\link{openmap}}
}
\description{
Download and plot map with the extend of a dataset with lat-long coordinates
}
\examples{
if(interactive()){
d <- read.table(sep=",", header=TRUE, text=
"lat, long # could e.g. be copied from googleMaps, rightclick on What's here?
43.221028, -123.382998
43.215348, -123.353804
43.227785, -123.368694
43.232649, -123.355895")

map <- pointsMap(lat, long, data=d)
map_utm <- pointsMap(lat, long, d, map=map, utm=TRUE)
axis(1); axis(2) # now in meters
projectPoints(d$lat, d$long)
scaleBar(map_utm, x=0.2, y=0.8, unit="mi", type="line", col="red", length=0.25)
pointsMap(lat, long, d[1:2,], map=map_utm, add=TRUE, col="red", pch=3, pargs=list(lwd=3))

d <- data.frame(long=c(12.95, 12.98, 13.22, 13.11), lat=c(52.40,52.52, 52.36, 52.45))
map <- pointsMap(lat,long,d, type="bing") # aerial map
}

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2016
}
\seealso{
\code{\link{projectPoints}}, \code{OpenStreetMap::\link[OpenStreetMap]{openmap}}
}
\keyword{hplot}
\keyword{spatial}

