% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ACL}
\alias{ACL}
\title{A function to compute Absolute Clustering Index (ACL)}
\usage{
ACL(x, c = NULL, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{c}{- a binary contiguity (adjacency) symetric matrix where each
element \emph{Cij} equals 1 if \emph{i}-th and \emph{j}-th spatial units
are adjacent, 0 otherwise.}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A vector with Absolute Clustering index
}
\description{
The more contiguous spatial units a group occupies
(forming an enclave within the zone) the more clustered and therefore
segregated it is. The function can be used in two ways:
 by providing a contiguity matrix or a geographic source (spatial
 object or shape file) wich will be used to compute the matrix within
 the function
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
contiguity <- contig(GreHSize)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'

ACL(x, c=contiguity)

ACL(x, spatobj = GreHSize)

ACL(x, folder = foldername, shape = shapename)
}
\references{
Massey D. S. and Denton N. A. (1988) \emph{
The dimensions of residential segregation}.
Social Forces 67(2),  pp. 281-315.
}
\seealso{
Mean proximity between members of a group: \code{\link{Pxx}}

Relative Clustering Index: \code{\link{RCL}}
}

