% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{area}
\alias{area}
\title{A function to compute the spatial units' areas}
\usage{
area(spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{spatobj}{- a Spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A vector with spatial units' areas.
}
\description{
The function is based on \pkg{rgdal} package and
can be used by providing a shape file or a R spatial object
(SpatialPolygonsDataFrame).
}
\examples{
area(GreHSize)

foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'
area(folder = foldername, shape = shapename)
}
\seealso{
Other spatial functions used for segregation indices
computation: \code{\link{contig}}, \code{\link{perimeter}},
\code{\link{distance}}, \code{\link{distcenter}},
\code{\link{boundaries}}, \code{\link{xgeo}}
}

