% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ordinalseg}
\alias{ordinalseg}
\title{A function to compute Reardon multi-group ordinal segregation indices}
\usage{
ordinalseg(x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group. The rows
represent the nominal categories (spatial units) and the columns the ordinal 
categories.}
}
\value{
A vector with Reardon multi-group ordinal segregation indices:
Lambda1 - ordinal generalization of the information theory index
Lambda2 - ordinal generalization of the variation ratio index
Lambda3 - ordinal square root index
Lambda4 - ordinal absolute difference index
}
\description{
A function to compute Reardon (2009) ordinal indices
}
\examples{
x <- GreHSize@data[ ,3:5]
ordinalseg(x) 

x1 <- matrix(nrow = 4, ncol = 3)
x1[1,] <- c(0, 0, 30)
x1[2,] <- c(0, 20, 10)
x1[3,] <- c(10, 20 ,0)
x1[4,] <- c(30, 0 ,0)

x2 <- matrix(nrow = 4, ncol = 3)
x2[1,] <- c(0, 30, 0)
x2[2,] <- c(0, 10, 20)
x2[3,] <- c(10, 0, 20)
x2[4,] <- c(30, 0, 0)

ordinalseg(x1)
ordinalseg(x2)
}
\references{
Reardon S. F. (2009) \emph{Measures of ordinal segregation}. 
Research on Economic Inequality, 17, pp. 129-155.
}
\seealso{
\code{\link{rankorderseg}}
}
