/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.utility;

import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtility {
    private JSONUtility() {
    }

    public static void appendJSONArray(JSONArray appendee, JSONArray appender) {
        int appenderSize = appender.length();
        for (int i = 0; i < appenderSize; ++i) {
            try {
                appendee.put(appender.get(i));
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
    }

    public static void JSONWriter(Writer fileWriter, Object jsonObject, boolean encode) throws JSONException, IOException {
        String jsonString = encode ? URLEncoder.encode(jsonObject.toString(), "UTF-8") : jsonObject.toString();
        int strLen = jsonString.length();
        int chunkSize = 1024;
        for (int start2 = 0; start2 < strLen; start2 += chunkSize) {
            int amountLeft = strLen - start2;
            int amountToWrite = chunkSize > amountLeft ? amountLeft : chunkSize;
            fileWriter.write(jsonString, start2, amountToWrite);
        }
        fileWriter.write("\n");
        fileWriter.flush();
        fileWriter.close();
    }

    public static void JSONWriterToString(StringBuffer fileWriter, Object jsonObject) throws JSONException, IOException {
        String jsonString = jsonObject.toString();
        fileWriter.append(jsonString);
        fileWriter.append("\n");
    }

    public static boolean equalsJsonArrays(JSONArray first, JSONArray second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return first == null;
        }
        if (first.length() != second.length()) {
            return false;
        }
        try {
            int length = first.length();
            for (int i = 0; i < length; ++i) {
                Object firstIndex = first.get(i);
                if (firstIndex instanceof JSONArray) {
                    if (second.get(i) instanceof JSONArray) {
                        if (JSONUtility.equalsJsonArrays((JSONArray)firstIndex, (JSONArray)second.get(i))) continue;
                        return false;
                    }
                    return false;
                }
                if (firstIndex instanceof JSONObject) {
                    if (second.get(i) instanceof JSONObject) {
                        if (JSONUtility.equalsJsonObjects((JSONObject)firstIndex, (JSONObject)second.get(i))) continue;
                        return false;
                    }
                    return false;
                }
                if (firstIndex.equals(second.get(i))) continue;
                return false;
            }
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public static boolean equalsJsonObjects(JSONObject first, JSONObject second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return first == null;
        }
        if (first.length() != second.length()) {
            return false;
        }
        try {
            Iterator iter = first.keys();
            while (iter.hasNext()) {
                String currKey = (String)iter.next();
                if (second.has(currKey)) {
                    if (first.get(currKey) instanceof JSONArray) {
                        if (second.get(currKey) instanceof JSONArray) {
                            if (JSONUtility.equalsJsonArrays((JSONArray)first.get(currKey), (JSONArray)second.get(currKey))) continue;
                            return false;
                        }
                        return false;
                    }
                    if (first.get(currKey) instanceof JSONObject) {
                        if (second.get(currKey) instanceof JSONObject) {
                            if (JSONUtility.equalsJsonObjects((JSONObject)first.get(currKey), (JSONObject)second.get(currKey))) continue;
                            return false;
                        }
                        return false;
                    }
                    if (first.get(currKey).equals(second.get(currKey))) continue;
                    return false;
                }
                return false;
            }
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }
}

