/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.creator;

import java.util.Map;
import java.util.Random;
import nu.xom.Node;
import org.andwellness.xml.datagenerator.creator.DataPointCreator;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteActivityDataPointCreator
extends DataPointCreator {
    private Logger _logger = Logger.getLogger(RemoteActivityDataPointCreator.class);

    @Override
    public DataPoint create(Node currentNode) {
        String displayType = currentNode.query("displayType").get(0).getValue();
        String nodeId = currentNode.query("id").get(0).getValue();
        DataPoint createdDataPoint = new DataPoint();
        createdDataPoint.setId(nodeId);
        createdDataPoint.setPromptType(DataPoint.PromptType.remote_activity);
        createdDataPoint.setDisplayType(displayType);
        Node propertyNode = currentNode.query("properties").get(0);
        Map<String, String> nodeProperties = this.extractProperties(propertyNode);
        int retries = Integer.parseInt(nodeProperties.get("retries"));
        int numIndices = ValueCreator.randomPositiveIntModulus(retries) + 1;
        JSONArray value2 = this.createJsonArray(numIndices);
        createdDataPoint.setValue(value2);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating a remote_activity data point with id " + nodeId + " and JSONArray " + value2);
        }
        return createdDataPoint;
    }

    private JSONArray createJsonArray(int numIndices) {
        Random r = new Random();
        JSONArray result = new JSONArray();
        for (int i = 0; i < numIndices; ++i) {
            JSONObject currEntry = new JSONObject();
            try {
                currEntry.put("First", true);
                currEntry.put("Second", 2);
                currEntry.put("Third", 3.0);
                currEntry.put("Timestamp", System.currentTimeMillis());
                currEntry.put("Index", i);
                currEntry.put("score", r.nextDouble() * 100.0);
                result.put(currEntry);
                continue;
            }
            catch (JSONException e) {
                this._logger.info("Problem creating stock JSONObject.", e);
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }
}

