% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagenomics-class.R
\name{metagenomics}
\alias{metagenomics}
\title{Sub-class metagenomics}
\description{
This is a sub-class that is compatible to data obtained from either 16S rRNA marker-gene sequencing or shot-gun metagenomics sequencing.
It inherits all methods from the abstract class \link{omics} and only adapts the \code{initialize} function.
It supports BIOM format data (v2.1.0 from \url{http://biom-format.org/}) in both HDF5 and JSON format, also pre-existing data structures can be used or text files.
When omics data is very large, data loading becomes very expensive. It is therefore recommended to use the \href{#method-reset}{\code{reset()}} method to reset your changes.
Every omics class creates an internal memory efficient back-up of the data, the resetting of changes is an instant process.
}
\examples{

## ------------------------------------------------
## Method `metagenomics$print`
## ------------------------------------------------

taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

# method 1 to call print function
taxa

# method 2 to call print function
taxa$print()


## ------------------------------------------------
## Method `metagenomics$reset`
## ------------------------------------------------

library(ggplot2)

taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

# Performs modifications
taxa$transform(log2)

# resets
taxa$reset()

# An inbuilt reset function prevents unwanted modification to the taxa object.
taxa$rankstat(feature_ranks = c("Kingdom", "Phylum", "Family", "Genus", "Species"))


## ------------------------------------------------
## Method `metagenomics$removeZeros`
## ------------------------------------------------

taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

# Sample subset induces empty features
taxa$sample_subset(treatment == "tumor")

# Remove empty features from countData and treeData
taxa$removeZeros()


## ------------------------------------------------
## Method `metagenomics$write_biom`
## ------------------------------------------------

taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

taxa$write_biom(filename = "output.biom")
file.remove("output.biom")

}
\seealso{
\link{omics}
}
\section{Super class}{
\code{\link[OmicFlow:omics]{OmicFlow::omics}} -> \code{metagenomics}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{countData}}{A path to an existing file, data.table or data.frame.}

\item{\code{metaData}}{A path to an existing file, data.table or data.frame.}

\item{\code{featureData}}{A path to an existing file, data.table or data.frame.}

\item{\code{treeData}}{A path to an existing newick file or class "phylo", see \link[ape]{read.tree}.}

\item{\code{biomData}}{A path to an existing biom file or hdf5 file, see \link[rhdf5]{h5read}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-metagenomics-new}{\code{metagenomics$new()}}
\item \href{#method-metagenomics-print}{\code{metagenomics$print()}}
\item \href{#method-metagenomics-reset}{\code{metagenomics$reset()}}
\item \href{#method-metagenomics-removeZeros}{\code{metagenomics$removeZeros()}}
\item \href{#method-metagenomics-write_biom}{\code{metagenomics$write_biom()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="DFE"><a href='../../OmicFlow/html/omics.html#method-omics-DFE'><code>OmicFlow::omics$DFE()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="alpha_diversity"><a href='../../OmicFlow/html/omics.html#method-omics-alpha_diversity'><code>OmicFlow::omics$alpha_diversity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="autoFlow"><a href='../../OmicFlow/html/omics.html#method-omics-autoFlow'><code>OmicFlow::omics$autoFlow()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="composition"><a href='../../OmicFlow/html/omics.html#method-omics-composition'><code>OmicFlow::omics$composition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="feature_merge"><a href='../../OmicFlow/html/omics.html#method-omics-feature_merge'><code>OmicFlow::omics$feature_merge()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="feature_subset"><a href='../../OmicFlow/html/omics.html#method-omics-feature_subset'><code>OmicFlow::omics$feature_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="normalize"><a href='../../OmicFlow/html/omics.html#method-omics-normalize'><code>OmicFlow::omics$normalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="ordination"><a href='../../OmicFlow/html/omics.html#method-omics-ordination'><code>OmicFlow::omics$ordination()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="rankstat"><a href='../../OmicFlow/html/omics.html#method-omics-rankstat'><code>OmicFlow::omics$rankstat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="removeNAs"><a href='../../OmicFlow/html/omics.html#method-omics-removeNAs'><code>OmicFlow::omics$removeNAs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="sample_subset"><a href='../../OmicFlow/html/omics.html#method-omics-sample_subset'><code>OmicFlow::omics$sample_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="samplepair_subset"><a href='../../OmicFlow/html/omics.html#method-omics-samplepair_subset'><code>OmicFlow::omics$samplepair_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="transform"><a href='../../OmicFlow/html/omics.html#method-omics-transform'><code>OmicFlow::omics$transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="validate"><a href='../../OmicFlow/html/omics.html#method-omics-validate'><code>OmicFlow::omics$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metagenomics-new"></a>}}
\if{latex}{\out{\hypertarget{method-metagenomics-new}{}}}
\subsection{Method \code{new()}}{
Initializes the metagenomics class object with \code{metagenomics$new()}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metagenomics$new(
  countData = NULL,
  metaData = NULL,
  featureData = NULL,
  treeData = NULL,
  biomData = NULL,
  feature_names = c("Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{countData}}{countData A path to an existing file or sparseMatrix.}

\item{\code{metaData}}{A path to an existing file, data.table or data.frame.}

\item{\code{featureData}}{A path to an existing file, data.table or data.frame.}

\item{\code{treeData}}{A path to an existing newick file or class "phylo", see \link[ape]{read.tree}.}

\item{\code{biomData}}{A path to an existing biom file, version 2.1.0 (http://biom-format.org/), see \link[rhdf5]{h5read}.}

\item{\code{feature_names}}{A character vector to name the feature names that fit the supplied \code{featureData}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{metagenomics} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metagenomics-print"></a>}}
\if{latex}{\out{\hypertarget{method-metagenomics-print}{}}}
\subsection{Method \code{print()}}{
Displays parameters of the metagenomics object via stdout.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metagenomics$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

# method 1 to call print function
taxa

# method 2 to call print function
taxa$print()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metagenomics-reset"></a>}}
\if{latex}{\out{\hypertarget{method-metagenomics-reset}{}}}
\subsection{Method \code{reset()}}{
Upon creation of a new \code{metagenomics} object a small backup of the original data is created.
Since modification of the object is done by reference and duplicates are not made, it is possible to \code{reset} changes to the class.
The methods from the abstract class \link{omics} also contains a private method to prevent any changes to the original object when using methods such as \code{ordination} \code{alpha_diversity} or \code{$DFE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metagenomics$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

# Performs modifications
taxa$transform(log2)

# resets
taxa$reset()

# An inbuilt reset function prevents unwanted modification to the taxa object.
taxa$rankstat(feature_ranks = c("Kingdom", "Phylum", "Family", "Genus", "Species"))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metagenomics-removeZeros"></a>}}
\if{latex}{\out{\hypertarget{method-metagenomics-removeZeros}{}}}
\subsection{Method \code{removeZeros()}}{
Removes empty (zero) values by row, column and tips from the \code{countData} and \code{treeData}.
This method is performed automatically during subsetting of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metagenomics$removeZeros()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

# Sample subset induces empty features
taxa$sample_subset(treatment == "tumor")

# Remove empty features from countData and treeData
taxa$removeZeros()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metagenomics-write_biom"></a>}}
\if{latex}{\out{\hypertarget{method-metagenomics-write_biom}{}}}
\subsection{Method \code{write_biom()}}{
Creates a BIOM file in HDF5 format of the loaded items via \href{#method-new}{'new()'}, which is compatible to the python biom-format version 2.1, see http://biom-format.org.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metagenomics$write_biom(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{A character variable of either the full path of filename of the biom file (e.g. \code{output.biom})}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{taxa_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
taxa <- readRDS(taxa_path)

taxa$write_biom(filename = "output.biom")
file.remove("output.biom")

}
\if{html}{\out{</div>}}

}

}
}
