% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CpG_summary.R
\name{CpG_summary}
\alias{CpG_summary}
\title{CpG_summary}
\usage{
CpG_summary(data, type = "class")
}
\arguments{
\item{data}{Requires a  data frame generated by score_genes; class - data frame}

\item{type}{Requires to specify if plotting is performed for location or class types; default is "class". Alternatively, select "location". Class - string}
}
\value{
multiple plots (class - plots) and a data frame with GC content (class - data frame)
}
\description{
CpG_summary function provides information on genes with CpG islands and GC content. The function checks genes against known CpG islands and provides various plots to assess emerging data features. The user can also specify if the plotting is necessary for location ("location") or protein class ("class"). Only genes with GC data are assessed.
}
\examples{
 \dontrun{
path_to_test_data<- system.file("extdata", "test_data.tabular", package="OmicInt")
# basic usage of CpG_summary
df<-utils::read.table(path_to_test_data)
return_df<-CpG_summary(df)
head(return_df)
}
}
