% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{rmsep_combi}
\alias{rmsep_combi}
\title{Symmetrized root MSE of Prediction}
\usage{
rmsep_combi(Xtst, Ytst, fit)
}
\arguments{
\item{Xtst}{Numeric vector or matrix.}

\item{Ytst}{Numeric vector or matrix.}

\item{fit}{\code{\link{o2m}} fit (on data without \code{Xtst} and \code{Ytst}).}
}
\value{
Mean squares difference between predicted Y and true Y
}
\description{
Calculates the symmetrized root MSE of prediction on test data. *Expected* to work in combination with \code{\link{loocv}}.
}
\details{
This function is the building block for \code{\link{loocv}}, as it produced the prediction error for test (left out) data.

This is a symmetrized version of \code{\link{rmsep}}, and is used by \code{\link{loocv}}. The predicion error of both \code{Xtst} and \code{Ytst} are calculated and summed.
Whether this is a good idea depends: If \eqn{X} and \eqn{Y} have similar meanings (LC-MS versus MALDI) this is a good thing to do. If the two matrices do not have similar meanings,
(Metabolomics versus Transcriptomics) then you may want to not sum up the two prediction errors or include weights in the sum.
}
