% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarisePopulationCharacteristics.R
\name{summarisePopulationCharacteristics}
\alias{summarisePopulationCharacteristics}
\title{Summarise the characteristics of the base population of a cdm_reference
object.}
\usage{
summarisePopulationCharacteristics(
  cdm,
  studyPeriod = c(NA, NA),
  sex = FALSE,
  ageGroup = NULL
)
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{studyPeriod}{Dates to trim the observation period. If NA,
min(observation_period_start_date) and/or max(observation_period_end_date)
are used.}

\item{sex}{Whether to stratify the results by sex.}

\item{ageGroup}{List of age groups to stratify by at index date.}
}
\value{
A summarised_result object.
}
\description{
Summarise the characteristics of the base population of a cdm_reference
object.
}
\examples{
\donttest{
cdm <- mockOmopSketch()

summarisedPopulation <- summarisePopulationCharacteristics(
  cdm = cdm,
  studyPeriod = c("2010-01-01", NA),
  sex = TRUE,
  ageGroup = NULL
)

summarisedPopulation |> print()

PatientProfiles::mockDisconnect(cdm = cdm)
}
}
