% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{remote_raw_download}
\alias{remote_raw_download}
\title{Download Raw Data from Remote Sources}
\usage{
remote_raw_download(
  hashed_data = NULL,
  file_path = NULL,
  ckan_url = NULL,
  ckan_key = NULL,
  ckan_package = NULL,
  s3_key_id = NULL,
  s3_secret_key = NULL,
  s3_region = NULL,
  s3_bucket = NULL
)
}
\arguments{
\item{hashed_data}{A character string representing the hashed identifier of the data to be downloaded.}

\item{file_path}{location and name of the zip file to create.}

\item{ckan_url}{A character string representing the CKAN base URL.}

\item{ckan_key}{A character string representing the CKAN API key.}

\item{ckan_package}{A character string representing the CKAN package identifier.}

\item{s3_key_id}{A character string representing the AWS S3 access key ID.}

\item{s3_secret_key}{A character string representing the AWS S3 secret access key.}

\item{s3_region}{A character string representing the AWS S3 region.}

\item{s3_bucket}{A character string representing the AWS S3 bucket name.}
}
\value{
Any return objects from the downloads.
}
\description{
This function downloads data from remote sources like CKAN and AWS S3.
It retrieves the data based on the hashed_data identifier and assumes the data is stored using the same naming conventions provided in the `remote_share` function.
}
\examples{
\dontrun{
  downloaded_data <- remote_raw_download(hashed_data = "example_hash",
                                     file_path = "your/path/file.zip",
                                     ckan_url = "https://example.com",
                                     ckan_key = "your_ckan_key",
                                     ckan_package = "your_ckan_package",
                                     s3_key_id = "your_s3_key_id",
                                     s3_secret_key = "your_s3_secret_key",
                                     s3_region = "your_s3_region",
                                     s3_bucket = "your_s3_bucket")
}

}
