% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superpixels.R
\name{load_binary}
\alias{load_binary}
\title{loads either 2- or 3-dimensional data (where the third dimension is equal to 3) from a binary file}
\usage{
load_binary(path, type)
}
\arguments{
\item{path}{a character string specifying a file path ( where the binary data is saved )}

\item{type}{a character string. Either '2d' or '3d' to indicate what kind of data data will be loaded from the specified \emph{path}}
}
\description{
loads either 2- or 3-dimensional data (where the third dimension is equal to 3) from a binary file
}
\details{
This function can be used to load either 2- or 3-dimensional data (where the third dimension is equal to 3) from a binary file. It is used in combination with the \emph{superpixels} function in case that the \emph{write_slic} parameter is not an empty string ("").
}
\examples{

\dontrun{

library(OpenImageR)

#------------------------------------------
# assuming the saved data are 2-dimensional
#------------------------------------------

path = "/my_dir/data.bin"

res = load_binary(path, type = '2d')

}

}
