% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warp_affine.R
\name{getAffineTransform}
\alias{getAffineTransform}
\title{Get Affine Transform}
\usage{
getAffineTransform(original_points, transformed_points)
}
\arguments{
\item{original_points}{a matrix object that corresponds to the original points}

\item{transformed_points}{a matrix object that corresponds to the transformed points}
}
\value{
a matrix
}
\description{
Get Affine Transform
}
\examples{

require(OpenImageR)

r = 600
c = 600
offset = 50

original_points = matrix(data = c(0, 0, r, 0, 0, c),
                         nrow = 3,
                         ncol = 2,
                         byrow = TRUE)

transformed_points = matrix(data = c(offset, 0, r, offset, 0, c-offset),
                            nrow = 3,
                            ncol = 2,
                            byrow = TRUE)

M_aff = getAffineTransform(original_points = original_points,
                           transformed_points = transformed_points)
M_aff
}
\references{
https://github.com/OlehOnyshchak/ImageTransformations/blob/master/AffineTransformation.ipynb
}
