% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadOMLTask.R
\name{uploadOMLTask}
\alias{uploadOMLTask}
\title{Upload a task to the OpenML server.}
\usage{
uploadOMLTask(task.type, data.id, target.feature, estimation.procedure,
  evaluation.measure = NULL, tags = NULL, description = NULL,
  confirm.upload = NULL, verbosity = NULL)
}
\arguments{
\item{task.type}{[character(1)]\cr
The type of the task to upload. See listOMLTaskTypes() to list all valid task types.}

\item{data.id}{[\code{integer(1)}]\cr
ID of the data set.}

\item{target.feature}{[character(1)]\cr
The target feature of the dataset.}

\item{estimation.procedure}{[character(1)]\cr
The estimation procedure for the evaluation. See listOMLEstimationProcedures() to list all procedures.}

\item{evaluation.measure}{[character(1)]\cr
The evaluation measure for the evaluation. See listOMLEvaluationMeasures() to list all possible measures.}

\item{tags}{[\code{character}]\cr
The tags that should be added after uploading.}

\item{description}{[\code{character(1)}|\code{\link{OMLDataSetDescription}}]\cr
Either an \code{\link{OMLDataSetDescription}} or a \code{character(1)} that describes the data. 
For the latter, all other relevant information is autogenerated from the \code{\link[mlr]{Task}}.}

\item{confirm.upload}{[\code{logical(1)}]\cr
Should the user be asked to confirm the upload?
Default is the setting from your config.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\description{
Share a task by uploading it to the OpenML server.
}
