% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxAutoStart.R
\name{mxAutoStart}
\alias{mxAutoStart}
\title{Automatically set starting values for an MxModel}
\usage{
mxAutoStart(model)
}
\arguments{
\item{model}{The MxModel for which starting values are desired}
}
\value{
an MxModel with new free parameter values
}
\description{
Automatically set starting values for an MxModel
}
\details{
This function automatically picks very good starting values for many models (RAM, LISREL, Normal), including multiple group versions of these.
It works for models with algebras. Models of continuous, ordinal, and joint ordinal-continous variables are also acceptable.
It works for model with covariance or raw data.
However, it does not currently work for models with definition variables, state space models, and item factor analysis models.

The method used to obtain new starting values is quite simple. The user's model is changed to an unweighted least squares (ULS) model. The ULS model is estimated and its final point estimates are returned as the new starting values.

Please note that ULS is sensitive to the scales of your variables. For example, if you have variables with means of 20 and variances of 0.001, then ULS will "weight" the means 20,000 times more than the variances and might result in zero variance estimates. Likewise if one variable has a variance of 20 and another has a variance of 0.001, the same problem may arise. To avoid this, make sure your variables are scaled accordingly. You could also use diagonally weighted least squares to obtain your own starting values.
}
\examples{
# Use the frontpage model with negative variances to show better
# starting values
library(OpenMx)
data(demoOneFactor)

latents  = c("G") # the latent factor
manifests = names(demoOneFactor) # manifest variables to be modeled

m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2, values=-.2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxPath(from = "one", to = manifests),
	mxData(demoOneFactor, type = "raw")
)

# Starting values imply negative variances!
mxGetExpected(m1, 'covariance')

# Use mxAutoStart to get much better starting values
m1s <- mxAutoStart(m1)
mxGetExpected(m1s, 'covariance')
}
