\name{bertinBase}
\alias{bertinBase}
\title{Workhorse for the biplot printing.}
\usage{bertinBase(nrow, ncol, labels="", labels.elements="", labels.left="",
    labels.right="", col.text=NA, cex.text=0.6,
    cex.elements=0.7, cex.constructs=0.7,
    col.fill=grey(0.8), border="white", xlim=c(0, 1),
    ylim=c(0, 1), margins=c(0, 1, 1), lheight=0.75,
    text.margin=0.005, elements.offset=c(0.002, 0.002),
    id=c(T, T), cc=0, cr=0, cc.old=0, cr.old=0,
    col.mark.fill="#FCF5A4", print=TRUE, byrow=FALSE,
    add=FALSE)
}
\description{Workhorse for the biplot printing. Prints a bertin to the output 
device. It uses the R base graphics system and 
this is very fast. This is useful for working with grids. Not so much for
producing high-quality output.}
\value{\code{NULL} just for printing.}
\keyword{internal}
\author{Mark Heckmann}
\arguments{\item{x}{\code{repgrid} object.}
\item{ratings}{Vector. rating scores are printed in the cells}
\item{margins}{Vector of length three (default \code{margins=c(0,1,1)}). 
1st element denotes the left, 2nd the upper and 3rd the 
right margin in npc coordinates (i.e. 0 to zero).}
\item{trim}{Vector (default \code{trim=c(F,F)}).If a number the string
is trimmed to the given number of characters. If set 
to TRUE the labels are trimmed to the available space}
\item{add}{Logical. Wether to add bertin to existent plot (default is 
\code{FALSE}). If \code{TRUE, plot.new()} will not be called
\code{par(new=TRUE)}.}
}

