% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_noise.R
\name{sig_noise}
\alias{sig_noise}
\alias{sig_noise.default}
\alias{sig_noise.OpenSpecy}
\title{Calculate signal and noise metrics for OpenSpecy objects}
\usage{
sig_noise(x, ...)

\method{sig_noise}{default}(x, ...)

\method{sig_noise}{OpenSpecy}(
  x,
  metric = "run_sig_over_noise",
  na.rm = TRUE,
  prob = 0.5,
  step = 20,
  breaks = seq(min(unlist(x$spectra)), max(unlist(x$spectra)), length =
    ((nrow(x$spectra)^(1/3)) * (max(unlist(x$spectra)) - min(unlist(x$spectra))))/(2 *
    IQR(unlist(x$spectra)))),
  sig_min = NULL,
  sig_max = NULL,
  noise_min = NULL,
  noise_max = NULL,
  abs = T,
  spatial_smooth = F,
  sigma = c(1, 1),
  threshold = NULL,
  ...
)
}
\arguments{
\item{x}{an \code{OpenSpecy} object.}

\item{metric}{character; specifying the desired metric to calculate.
Options include \code{"sig"} (mean intensity), \code{"noise"} (standard
deviation of intensity), \code{"sig_times_noise"} (absolute value of
signal times noise), \code{"sig_over_noise"} (absolute value of signal /
noise), \code{"run_sig_over_noise"} (absolute value of signal /
noise where signal is estimated as the max intensity and noise is
estimated as the height of a low intensity region.),
\code{"log_tot_sig"} (sum of the inverse log intensities, useful for spectra  in log units),
\code{"tot_sig"} (sum of intensities), or \code{"entropy"} (Shannon entropy of intensities)..}

\item{na.rm}{logical; indicating whether missing values should be removed
when calculating signal and noise. Default is \code{TRUE}.}

\item{prob}{numeric single value; the probability to retrieve for the quantile where
the noise will be interpreted with the run_sig_over_noise option.}

\item{step}{numeric; the step size of the region to look for the run_sig_over_noise option.}

\item{breaks}{numeric; the number or positions of the breaks for entropy calculation.
Defaults to infer a decent value from the data.}

\item{sig_min}{numeric; the minimum wavenumber value for the signal region.}

\item{sig_max}{numeric; the maximum wavenumber value for the signal region.}

\item{noise_min}{numeric; the minimum wavenumber value for the noise region.}

\item{noise_max}{numeric; the maximum wavenumber value for the noise region.}

\item{abs}{logical; whether to return the absolute value of the result}

\item{spatial_smooth}{logical; whether to spatially smooth the sig/noise using the xy
coordinates and a gaussian smoother.}

\item{sigma}{numeric; two value vector describing standard deviation for smoother in
each dimension, y is specified first followed by x, should be the same for each in most cases.}

\item{threshold}{numeric; if NULL, no threshold is set, otherwise use a numeric value
to set the target threshold which true signal or noise should be above. The
function will return a logical value instead of numeric if a threshold is set.}

\item{\ldots}{further arguments passed to subfunctions; currently not used.}
}
\value{
A numeric vector containing the calculated metric for each spectrum in the
\code{OpenSpecy} object or logical value if threshold is set describing if
the numbers where above or equal to (TRUE) the threshold.
}
\description{
This function calculates common signal and noise metrics for \code{OpenSpecy}
objects.
}
\examples{
data("raman_hdpe")

sig_noise(raman_hdpe, metric = "sig")
sig_noise(raman_hdpe, metric = "noise")
sig_noise(raman_hdpe, metric = "sig_times_noise")

}
\seealso{
\code{\link[=restrict_range]{restrict_range()}}
}
