% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CirClust.R
\name{CirClust}
\alias{CirClust}
\title{Circular Data Clustering}
\usage{
CirClust(O, K, Circumference, method = c("FOCC", "HEUC", "BOCC"))
}
\arguments{
\item{O}{a vector of circular data points. They can be coordinates
along the circle based on distance, or angles around the circle.}

\item{K}{the number of clusters}

\item{Circumference}{the circumference of the circle where
data are located}

\item{method}{the circular clustering method.
\code{"FOCC"}: fast and optimal, the default method;
  \code{"HEUC"}: based on heuristic k-means, fast but not necessarily optimal;
  \code{"BOCC"}: brute-force based on Ckmeans.1d.dp, slow but optimal,
  included to provide a baseline.}
}
\value{
An object of class \code{"CirClust"} which has a \code{plot}
 method. It is a list with the following components:



\item{ID}{the starting index of the frame with minimum SSQ}

\item{Border}{the borders of \code{K} clusters}

\item{cluster}{a vector of clusters assigned to each element in \code{O}.
Each cluster is indexed by an integer from 1 to \code{K}.}

\item{centers}{a numeric vector of the means for each cluster in the circular data.}

\item{withinss}{a numeric vector of the within-cluster sum of squares for each cluster.}

\item{size}{a vector of the number of elements in each cluster.}

\item{totss}{the total sum of squared distances between each element and the sample mean.
This statistic is not dependent on the clustering result.}

\item{tot.withinss}{the total sum of within-cluster squared distances between
 each element and its cluster mean. This statistic is minimized given the number of clusters.}

\item{betweenss}{the	sum of squared distances between each cluster mean and sample mean.
This statistic is maximized given the number of clusters.}

\item{O_name}{a character string. The actual name of the \code{O} argument.}
}
\description{
Perform clustering on circular data to minimize the
  within-cluster sum of squared distances.
}
\details{
In clustering \eqn{N} circular points into \eqn{K} clusters, the "FOCC" algorithm
is reproducible with runtime \eqn{O(K N \log^2 N)}{O(K N log^2 N)};
The "HEUC" algorithm, not always reproducible, calls the \code{kmeans} function repeatedly;
The "BOCC" algorithm with runtime \eqn{O(KN^2)}, reproducible but slow, is done via
repeatedly calling the \code{Ckmeans.1d.dp} function.
}
\examples{
O <- c(1,2, 10,11,12,13,14,15, 27,28,29,30,31,32, 40,41)

K <- 3

Circumference <- 42

# Perform circular clustering:
output <- CirClust(O, K, Circumference)

# Visualize the circular clusters:
opar <- par(mar=c(1,1,2,1))
plot(output)
par(opar)


}
