% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FramedClust.R
\name{FramedClust}
\alias{FramedClust}
\title{Framed Data Clustering}
\usage{
FramedClust(
  X,
  K,
  frame.size,
  first.frame = 1,
  last.frame = length(X) - frame.size + 1,
  method = c("linear.polylog", "kmeans", "Ckmeans.1d.dp")
)
}
\arguments{
\item{X}{a vector of data points to perform framed clustering}

\item{K}{the number of clusters in each frame}

\item{frame.size}{the number of points from X to be included in each frame.
It is not the width of the frame.}

\item{first.frame}{starting index of the first frame to be clustered.
The first point in the first frame is \code{X[first.frame]}.}

\item{last.frame}{starting index of the last frame to be clustered.
The first point in the first frame is \code{X[last.frame]}.}

\item{method}{the framed clustering method. See Details.}
}
\value{
An object of class \code{"FramedClust"} which has a \code{plot}
 method. It is a list with the following components:

\item{cluster}{a vector of clusters assigned to each element in x.
Each cluster is indexed by an integer from 1 to K.
NA represents points from X that are outside the optimal frame,
thus not part of any cluster.}

\item{centers}{a numeric vector of the means for each cluster
in the frame.}

\item{withinss}{a numeric vector of the within-cluster sum of
squared distances for each cluster.}

\item{size}{a vector of the number of elements in each cluster.}

\item{totss}{total sum of squared distances between each element
 and the sample mean. This statistic is not dependent on
 the clustering result.}

\item{tot.withinss}{total sum of within-cluster squared
distances between each element and its cluster mean.
This statistic is minimized given the number of clusters.}

\item{betweenss}{sum of squared distances between each
cluster mean and sample mean. This statistic is maximized
given the number of clusters.}

\item{X_name}{a character string. The actual name of
the \code{X} argument.}
}
\description{
Find a frame of given size, among all possible such frames
on the input data, to minimize the minimum within-cluster
sum of square distances.
}
\details{
The method option \code{"linear.polylog"} (default) performs
 fast optimal framed clustering. The runtime is
 \eqn{O(K N \log^2 N)}{O(K N log^2 N)}.

The \code{"kmeans"} option repeatedly calling the heuristic
 k-means algorithm in all frames without any guarantee of
 cluster optimality.

The method option \code{"Ckmeans.1d.dp"} performs optimal framed
 clustering by repeatedly finding the best clustering within
 each frame using the \code{"Ckmeans.1d.dp"} method. At a runtime
 of \eqn{O(K N^2)}{O(K N^2)}, the algorithm is slow but optimal.
 It is included to provide a baseline.
}
\examples{
N <- 100
X <- rnorm(N)
K <- 5
frame.size <- 60

result <- FramedClust(X, K, frame.size)
plot(result, main="Example 1. Framed clustering on all frames")

frame.size <- 40
first.frame <- 30
last.frame <- 50
method <- "linear.polylog"

result <- FramedClust(X, K, frame.size, first.frame,
                      last.frame, method)
plot(result, main="Example 2. Framed clustering on a subset of frames")
}
