% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariateoutlierdetection.R
\name{UnivariateOutlierDetection}
\alias{UnivariateOutlierDetection}
\title{Univariate Outlier Detection(Intersection of all the methods)}
\usage{
UnivariateOutlierDetection(x, k = 0.05 * length(x), cutoff = 0.95,
  dist = FALSE, dens = FALSE, depth = FALSE, Method = "euclidean",
  rnames = FALSE)
}
\arguments{
\item{x}{vector for which outliers are to be found}

\item{k}{No. of nearest neighbours to be used for distance methods, default value is 0.05*nrow(x)}

\item{cutoff}{Percentile threshold used for outlier detection using bootstrapping, default value is 0.95}

\item{dist}{Logical value indicating whether distance based methods should be used or not, default is False}

\item{dens}{Logical value indicating whether density based method should be used or not, default is False}

\item{depth}{Logical value indicating whether depth based method should be used or not, default is False}

\item{Method}{Distance method, default is euclidean}

\item{rnames}{Logical value indicating whether the dataset has rownames, default value is False}
}
\value{
Outlier Observations: A vector of outlier observations

Location of Outlier: Vector of Sr. no. of outliers
}
\description{
Takes a vector and finds its outliers using combination of different methods
}
\details{
UnivariateOutlierDetection finds outlier observations for an univariate data using different methods and based on all the methods, labels an observation as outlier(intersection of all the methods). It also shows the scatterplot of the data with labelled outliers with observation no. as x-axis.
}
\examples{
#Create dataset
X=iris[,1:4]
#Outlier detection
depthout(X,cutoff=0.05)
UnivariateOutlierDetection(iris[,1],cutoff=.95,Method="euclidean",rnames=FALSE)
}
\author{
Vinay Tiwari, Akanksha Kashikar
}
