% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PACLasso.R
\name{lasso.ineq}
\alias{lasso.ineq}
\title{Complete Run of Constrained LASSO Path Function with Inequality Constraints}
\usage{
lasso.ineq(x, y, C.full, b, l.min = -2, l.max = 6, step = 0.2,
  beta0 = NULL, verbose = F, max.it = 12, intercept = T,
  normalize = T, backwards = F)
}
\arguments{
\item{x}{independent variable matrix of data to be used in calculating PaC coefficient paths}

\item{y}{response vector of data to be used in calculating PaC coefficient paths}

\item{C.full}{complete constraint matrix C (with inequality constraints of the form \code{C.full}*\code{beta} >= \code{b}))}

\item{b}{constraint vector b}

\item{l.min}{lowest value of lambda to consider (used as 10^\code{l.min}). Default is -2}

\item{l.max}{largest value of lambda to consider (used as 10^\code{l.max}). Default is 6}

\item{step}{step size increase in lambda attempted at each iteration (by a factor of 10^\code{step}). Default is 0.2}

\item{beta0}{initial guess for beta coefficient vector. Default is NULL (indicating
initial vector should be calculated by algorithm)}

\item{verbose}{should function print output at each iteration (TRUE) or not (FALSE). Default is FALSE}

\item{max.it}{maximum number of times step size is halved before the algorithm terminates and gives a warning. Default is 12}

\item{intercept}{should intercept be included in modeling (TRUE) or not (FALSE). Default is TRUE.}

\item{normalize}{should X data be normalized. Default is TRUE}

\item{backwards}{which direction should algorithm go, backwards from lambda = 10^\code{l.max} (TRUE)
or forwards from 10^\code{l.max} and then backwards if algorithm gets stuck (FALSE).
Default is FALSE.}
}
\value{
\code{coefs} A \code{p} by length(\code{lambda}) matrix with each column corresponding to the beta estimate for that lambda

\code{lambda} vector of values of lambda that were fit

\code{intercept} vector with each element corresponding to intercept for corresponding lambda

\code{error} Indicator of whether the algorithm terminated early because max.it was reached
}
\description{
This is a wrapper function for the \code{lars.c} PaC
  constrained Lasso function. \code{lasso.c} controls the overall path,
  providing checks for the path and allowing the user to control
  how the path is computed (and what to do in the case of a stopped path).
}
\examples{
random_data = generate.data(n = 500, p = 20, m = 10)
lasso_fit = lasso.ineq(random_data$x, random_data$y, random_data$C.full, random_data$b)
lasso_fit$lambda
lasso_fit$error
### The coefficients for the first lambda value
lasso_fit$coefs[1,]
### Example of code where path is unable to be finished
### (only one iteration), so both directions will be tried
lasso_err = lasso.ineq(random_data$x, random_data$y, random_data$C.full,
random_data$b, max.it = 1)
lasso_err$error
lasso_err$lambda
}
\references{
Gareth M. James, Courtney Paulson, and Paat Rusmevichientong (JASA, 2019) "Penalized and Constrained Optimization."
(Full text available at http://www-bcf.usc.edu/~gareth/research/PAC.pdf)
}
