% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainpafway.R
\name{pafway_edge_weights}
\alias{pafway_edge_weights}
\title{Find pairwise-associations between annotations in a network with edge weights.}
\usage{
pafway_edge_weights(GO, edges, GOtypes, exact = TRUE,
  adjustByEdgeCount = FALSE, step = 0.001, thresholdZero = 1e-04)
}
\arguments{
\item{GO}{A vector of Strings, equal to the length of all the nodes.  The names of the vector should be the names of the nodes.  The values should either be the functional annotations, or a concatenation of the functional annotations, separated by a "_" symbol.}

\item{edges}{A matrix of Strings, with at least three columns.  Each row will represent an edge, linking the node in the first column to the node in the second column, and the third column will contain an edge weight.  Please make sure the node names are the same as those in "GO"}

\item{GOtypes}{This is a vector that contains the functional annotations or GO terms that are of interest}

\item{exact}{A boolean.  If it is true, it will look for an exact match between the term in GOtypes and the vector GO.  Otherwise, it will look for substrings.}

\item{adjustByEdgeCount}{A boolean.  If true, then the probability of observing a functional annotation will be calculated in terms of the number of nodes, but if it is false, it is calculated in terms of the number of edges that contain that node.}

\item{step}{FFT is used to speed up the calculation.  In the first step, a certain number of values are evenly sampled from the function, across its range.  This value will determine the distance between sampled points.}

\item{thresholdZero}{In order to decrease the space and time requirements, values in the probability distributions that are below a certain threshold are set to be exactly zero.  This is the threshold.}
}
\value{
A matrix that has the same number of rows and columns as length(GOtypes).  This will contain p-values.
}
\description{
Find pairwise-associations between annotations in a network with edge weights.
}
\examples{
nodes=paste("node", c(1:10))
set.seed(123)
randomGO=c("A", "B", "C")[sample(c(1:3), 10, replace=TRUE)]
names(randomGO)=nodes
edgesRandom=sapply(c(1:20), function(i){
   nodes[sample(10, 2)]
})
getBinomPvalueRandom1=pafway_edge_weights(randomGO, cbind(t(edgesRandom),
rnorm(length(edgesRandom[1,]), 1, 0.001)), unique(randomGO))
}
