% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palmo.R
\docType{class}
\name{palmo-class}
\alias{palmo-class}
\alias{palmo}
\title{palmo class}
\value{
PALMO S4 class
}
\description{
This function creates \emph{PALMO} class object. All the raw data and results
from PALMO are stored in this object.
}
\section{Fields}{

\describe{
\item{\code{raw}}{list, contains user entered annotation and expression dataframe or
object}

\item{\code{curated}}{list, contains curated input data}

\item{\code{result}}{list, output from \emph{PALMO} stored in result list}

\item{\code{nDonors}}{numeric, number of donors in the input data}

\item{\code{rownames}}{character, row names of the expression data}

\item{\code{colnames}}{character, column names of the expression data}

\item{\code{housekeeping_genes}}{character, user-defined housekeeping genes listed}

\item{\code{datatype}}{character, datatype used like bulk or singlecell}

\item{\code{omics}}{character, omics such as RNA, scRNA, scATAC}

\item{\code{featureSet}}{character, parameters used for variance analysis}

\item{\code{meanThreshold}}{numeric, Average expression threshold}

\item{\code{cvThreshold}}{numeric, CV threshold}

\item{\code{median_cvThreshold}}{numeric, median of CV threshold (from inter-donor)}

\item{\code{groupName}}{character, group defined by user like celltype, cluster}

\item{\code{group_oi}}{character, selected types from user-defined group list}

\item{\code{donorThreshold}}{numeric, minimum donors to explore}

\item{\code{groupThreshold}}{numeric, minimum group types to explore}

\item{\code{topFeatures}}{numeric, number of top features to retrieve}

\item{\code{donor_sep}}{character, donor and group separator such as ':'}

\item{\code{cor_method}}{character, correelation method 'pearson', 'spearman'}

\item{\code{clusterBy}}{character, cluster by a group (celltype or cluster)}

\item{\code{z_cutoff}}{numeric, z-cutoff value for outlier analysis}

\item{\code{filePATH}}{character, PATH of outout directory}
}}

