% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatePamObject.R
\name{updatePamObject}
\alias{updatePamObject}
\title{Update PAMpal S4 Object}
\usage{
updatePamObject(x)
}
\arguments{
\item{x}{an \linkS4class{AcousticStudy}, \linkS4class{AcousticEvent},
or \linkS4class{PAMpalSettings} object}
}
\value{
the same object as \code{x} with any slot changes made
}
\description{
Updates older versions of PAMpal's S4 objects to stop "validOjbect"
warning messages
}
\details{
As of v0.12.0 this updates any previous version's PAMpalSettings
  objects to have the new "settings" slot, as well as updating any 
  PAMpalSettings objects within an AcousticStudy
}
\examples{

\dontrun{
pps <- new('PAMpalSettings')
# manually breaking this S4 class, don't try this at home
attr(pps, 'settings') <- NULL
# This will now give an error
pps
pps <- updatePamObject(pps)
# Fixed!
pps
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
