% Generated by roxygen2 (4.0.2): do not edit by hand
\name{s2ar}
\alias{s2ar}
\title{Finding optimal lag for dfgls test}
\usage{
s2ar(yts, penalty, kmax, kmin)
}
\arguments{
\item{yts}{A NxT matrix containing the data to find kstar for.}

\item{penalty}{a binary selection of 0 or 1. 0 uses the MAIC, a penalty on
k that accounts for the bias in the sum of the autoregressive coefficients.
 1 uses the more general form MIC.}

\item{kmax}{The maximum number of lags for the vector autoregressions. An
upper bound of \code{(12x(T/100)^.25)^8} is suggested
in Schwert (1989)}

\item{kmin}{The minimum number of lags for the vector autoregression. k equal to 0
is a reasonable point.}
}
\value{
kstar A vector of optimal lags for each column of yts
}
\description{
This function finds the optimal lag kstar for the dfgls
test.
}
\references{
Schwert, G. W. 1989. Tests for unit roots: A Monte Carlo
investigation. Journal of Business and Economic Statistics 2: 147-159.

           Serana Ng and P. Perron. 2000. Lag length selection and the construction of unit root
tests with good size and power. Econometrica 69:1519-1554.
}

