% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Activity_summary.R
\name{Activity_summary}
\alias{Activity_summary}
\title{Activity Summary--Standing and Stepping}
\usage{
Activity_summary(final_dat)
}
\arguments{
\item{final_dat}{cleaned final data that is between record getup time and sleep time}
}
\value{
\code{total_number_of_activity_bouts} Total number of activity bouts

\code{mean_activity_bout_length} Average length of activity bout

\code{prop_of_activity_time_greater_5min} Proportions of activity greater than 5 minutes

\code{prop_of_activity_time_greater_10min} Proportions of activity greater than 10 minutes

\code{prop_of_activity_time_greater_30min} Proportions of activity greater than 30 minutes

\code{total_activity_time_greater_5min} Total activity time in the bouts greater than 5 minutes

\code{total_activity_time_greater_10min} Total activity time in the bouts greater than 10 minutes

\code{total_activity_time_greater_30min} Total activity time in the bouts greater than 30 minutes

\code{percentile_activity_time_5} 5\% percentile of activity bouth length

\code{percentile_activity_time_25} 25\% percentile of activity bouth length

\code{percentile_activity_time_50} 50\% percentile of activity bouth length

\code{percentile_activity_time_75} 75\% percentile of activity bouth length

\code{percentile_activity_time_95} 95\% percentile of activity bouth length

\code{alpha_activity} alpha of activity time, see details_

\code{stepping_to_standing_ratio} Ratio of stepping to standing, the ratio of total stepping hours to standing hours

\code{table} A table that combine all outputs
}
\description{
Summarize Standing and Stepping activity measures
}
\details{
\code{alpha_activity} is defined by \code{1+1/M}, where \code{M} is the average of \code{log(activity bout length /minimum activity bout length)}_
}
\examples{
 data(sampledata);Activity_summary(sampledata)
}

